#include <iostream>
#include <vector>
#include <cmath>

using namespace std;
struct Asteroid{
  double cx;
  double cy;
  double r;
  bool valid;
};

double Dist(double x1, double y1, double x2, double y2){
  return sqrt(pow(x1-x2,2) + pow(y1-y2,2));
}

void Swap(double& a, double& b){
  double temp = a;
  a = b;
  b = temp;
}

// is c between a and b?
bool Inside(double a, double b, double c){
  if(a <= c && c <= b)
    return true;
  if(b <= c && c <= a)
    return true;
  else
    return false;
}

int Next_Intersection(double cur_x, double cur_y, double dest_x, double dest_y, double& start_x, double& start_y, double& end_x, double& end_y, const vector<Asteroid>& field){
  int best_pos = -1;
  int best_dist = -1;
  for(int i = 0; i < field.size(); i++){
    // shift so circle is at origin
    
    double x1 = cur_x-field[i].cx;
    double x2 = dest_x-field[i].cx;
    double y1 = cur_y-field[i].cy;
    double y2 = dest_y-field[i].cy;

    double dx = x2-x1;
    double dy = y2-y1;
    double dr2 = dx*dx+dy*dy;
    double determ = x1*y2-x2*y1;

    double discrim = (field[i].r*field[i].r * dr2)-(determ*determ);
    if(discrim > 0 && field[i].valid){ // then we hit the circle twice
      double first_x, first_y, second_x, second_y;
	first_y = (-1*determ*dx + abs(dy)*sqrt(discrim))/dr2 + field[i].cy;
	second_y = (-1*determ*dx-abs(dy)*sqrt(discrim))/dr2 + field[i].cy;

	first_x = (determ*dy+dx*sqrt(discrim))/dr2 + field[i].cx;
	second_x = (determ*dy-dx*sqrt(discrim))/dr2 + field[i].cx;
	
	if(dy < 0){
	  Swap(first_x, second_x); // formula is determ*dy +/- sign(dy)
	}
	if(Dist(cur_x, cur_y, first_x, first_y) > Dist(cur_x, cur_y, second_x, second_y)){
	  // then our "first" point is on the wrong side of the circle
	  Swap(first_x, second_x);
	  Swap(first_y, second_y);
	}
	double cur_dist = Dist(cur_x, cur_y, first_x, first_y);
	if((best_dist == -1 || cur_dist < best_dist) && Inside(cur_x, dest_x, first_x) && Inside(cur_y, dest_y, first_y)){
	  best_pos = i;
	  best_dist = cur_dist;
	  start_x = first_x;
	  start_y = first_y;
	  end_x = second_x;
	  end_y = second_y;
	}
    }
  }
  return best_pos;
}

double Around_Circle(double x1, double y1, double x2, double y2, Asteroid a){
  double length = Dist(x1,y1,x2,y2);
  //  double x = length/2*a.r;
  //  if(x > 1)
  //    x = 1; // roundoff nonsense
  double cos_t = 1-(length*length/(2*a.r*a.r));
  double angle =acos(cos_t);
  // cout << "angle: " << angle << endl;
  double result = angle * a.r;  // 2pir * a/2pi
  return result;
}
  
int main(){
  int cur_case = 1;
  int n;
  cin >> n;
  while(n > 0){
    vector<Asteroid> field(n);
    for(int i = 0; i < n; i++){
      
      cin >> field[i].cx;
      cin >> field[i].cy;
      cin >> field[i].r;
      field[i].valid = true;
      
    }
    double cur_x, cur_y;
    cin >> cur_x >>cur_y;
    double dest_x, dest_y;
    cin >> dest_x>> dest_y;
    int pos = 0;
    double dist =0;
    double start_x, start_y; // where we hit the circle
    double end_x, end_y; // where we leave the circle
    while( pos != -1){
      pos = Next_Intersection(cur_x, cur_y, dest_x, dest_y, start_x, start_y, end_x, end_y, field);
      //     cout << "Intersecting asteroid " << pos << " at (" << start_x << "," << start_y << ") to (" << end_x << "," << end_y << endl;
      if(pos >=0){
	double line = Dist(cur_x, cur_y, start_x, start_y);
	//	cout << "line to asteroid: " << line << endl;
	double arc = Around_Circle(start_x, start_y, end_x, end_y, field[pos]);
	//	cout << "Arc around circle: " << arc << endl;
	dist = dist + arc + line;
	cur_x = end_x;
	cur_y = end_y;
	//		cout << "dist: " << dist << endl;
	field[pos].valid= false;
      }
    }
    dist = dist + Dist(cur_x, cur_y, dest_x, dest_y);
    cout << "Case " << cur_case <<": " << dist << endl;
    cur_case++;
    cin >> n;

  }
  return 0;
}
    
