#include <iostream>
#include <vector>

using namespace std;

int Find_Min_Unvisited(const vector<bool>& visited, const vector<int>& d){
  int best_dist = -1;
  int best_pos = -1;
  for(int i = 0; i < visited.size(); i++){
    if(!visited[i] && d[i] != -1){
      if(best_dist == -1 || d[i] < best_dist){
	best_dist = d[i];
	best_pos = i;
      }
    }
  }
  return best_pos;
}


int main(){
  int cur_case = 1;
  int n;
  cin >> n;
  while(n > 0){
    int t;
    cin >>t;
    vector<int> coverages(n);
    for(int i = 0; i < n; i++)
      cin >> coverages[i];
    vector<vector<int> > Adjacency(n);
    for(int i = 0; i < n; i++)
      Adjacency[i].resize(n, -1);
    int r;
    cin >>r;
    for(int i = 0; i < r; i++){
      int v,w,d;
      cin >> v >> w>> d;
      Adjacency[v][w]=d;
      Adjacency[w][v] = d;
    }
    vector<bool> visited(n, false);
    vector<int> dists(n, -1);
    dists[0] = 0;
    for(int i = 0; i < n-1; i++){
      // basically run Dijkstra
      int s = Find_Min_Unvisited(visited, dists);
      visited[s] = true;
      for(int j = 0; j < n; j++){
	if(Adjacency[s][j] != -1){
	  if(dists[j] == -1)
	    dists[j] = dists[s] + Adjacency[s][j];
	  else
	    dists[j] = min(dists[j], dists[s]+Adjacency[s][j]);
	}
      }
    }
    // now who is the best time and coverage?
    int best_time = t+1;
    int best_coverage = -1;
    for(int i = 0; i < n; i++){
      if(dists[i] <= t){
	if(coverages[i] > best_coverage || (coverages[i] == best_coverage &&
					    dists[i] < best_time)){
	  best_coverage = coverages[i];
	  best_time = dists[i];
	}
      }
    }
    cout << "Case " <<cur_case << ": " << best_coverage << " " << best_time << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}

	
