#include <iostream>
#include <vector>

using namespace std;
// well, I thought this was Dynamic Programming, but I think it's not,
// since you can get to a square in multiple ways, through different
// numbers of moves, and it matters what way you can get to it
// So I think it's better to do it as BFS

struct point{
  int r;
  int c;
  int dist;
};

int Solve(const vector<vector<int> >& Grid, int sr, int sc, int er, int ec){
  vector<vector<bool> > visited(Grid.size());
  for(int i = 0; i < visited.size(); i++)
    visited[i].resize(Grid[i].size(), false);

  vector<point> queue;
  int queue_pos;
  point start;
  start.r = sr;
  start.c = sc;
  start.dist = 0;
  queue.push_back(start);
  queue_pos = 0;
  visited[sr][sc] = true;
  point cur;
  while(queue_pos < queue.size()){
    cur = queue[queue_pos];
    //   cout << "Processing " << cur.r << ", " << cur.c << ": " << cur.dist << endl;
    if(cur.r == er && cur.c == ec)
      return cur.dist;
    int offset = Grid[cur.r][cur.c];
    point next;
    next.dist = cur.dist+1;
    // north
    next.r= cur.r - offset;
    next.c = cur.c;
    if(next.r >= 0 && !visited[next.r][next.c]){
      visited[next.r][next.c] = true;
      queue.push_back(next);
    }
    //south
    next.r = cur.r + offset;
    if(next.r < Grid.size() && !visited[next.r][next.c]){
      visited[next.r][next.c] = true;
      queue.push_back(next);
    }
    // east
    next.r = cur.r;
    next.c = cur.c+offset;
    if(next.c < Grid[next.r].size() && !visited[next.r][next.c]){
      visited[next.r][next.c] = true;
      queue.push_back(next);
    }
    // west
    next.c = cur.c-offset;
    if(next.c >= 0 && !visited[next.r][next.c]){
      visited[next.r][next.c] = true;
      queue.push_back(next);
    }
    queue_pos++;
  }
  // if we get here, we couldn't reach the exit
    return -1;
  
}
  

int main(){
  int cur_case = 1;
  int r, c;
  cin >> r >> c;
  while(r > 0){
    vector<vector<int> >Grid(r);
    for(int i = 0; i < r; i++){
      Grid[i].resize(c);
      for(int j = 0;j < c; j++)
	cin >> Grid[i][j];
    }

    int sr, er,sc,ec;
    cin >> sr >> sc >> er >> ec;
   
    int total = Solve(Grid,sr,sc,er,ec);
    if(total > 0){
      cout << "Case " << cur_case << ": " << total << endl;
    }
    else
      cout << "Case " << cur_case << ": Impossible" << endl;
    cur_case++;
    cin >> r >> c;
  }
  return 0;
}
