#include <iostream>
#include <vector>

using namespace std;

struct point{
  int r;
  int c;
};

int Disruption_Factor(point my_loc, point singer_loc, int singer_disruption){
  // if they are in front of us, their row is < our row
  if(singer_loc.r < my_loc.r){
    return max(0, singer_disruption-3*(my_loc.r-singer_loc.r));
  }
  //if they are in the same row, it's based on column difference
  if(singer_loc.r == my_loc.r){
    int col_diff = abs(singer_loc.c-my_loc.c);
    return max(0, singer_disruption-2*col_diff);
  }

  // if they are behind you, their row is > our row.  It's the only
  // possible case left
  return max(0, singer_disruption-(singer_loc.r-my_loc.r));
}

int Disruption(point my_loc, const vector<point>& singers, const vector<int>& disruptions){
  int total_disruption = 0;
  for(int i = 0; i < singers.size(); i++){
    int cur = Disruption_Factor(my_loc, singers[i], disruptions[i]);
    //  cout << "singer at r: " << singers[i].r << ", c: " << singers[i].c << " has disruption " << cur << endl;
    total_disruption += cur;
  }
  return total_disruption;
}

int main(){
  int cur_case = 1;
  int r,c;
  cin >> r >> c;
  while(r > 0){
    int e;
    cin >> e;
    vector<point> empty(e);
    for(int i = 0; i < e; i++){
      cin >> empty[i].r;
      cin >> empty[i].c;
    }
    int s;
    cin >> s;
    vector<point> singers(s);
    vector<int> disruptions(s);
    for(int i = 0; i < s; i++){
      cin >> singers[i].r;
      cin >> singers[i].c;
      cin >> disruptions[i];
    }
    int best_total = -1;
    for(int i = 0; i < empty.size(); i++){
      int cur_total = Disruption(empty[i], singers, disruptions);
      //   cout << "Location: " << i << " at r: " << empty[i].r << ", c: " << empty[i].c << "Disruption: " << cur_total << endl;
      if(best_total == -1 || cur_total < best_total)
	best_total = cur_total;
    }
    cout << "Case " << cur_case << ": " << best_total << endl;
    cur_case++;
    cin >> r >> c;
  }
  return 0;
}
    
