#include <iostream>
#include <vector>

using namespace std;

struct interval{
  int start;
  int end;
};

void Print_Intervals(vector<interval>& blocked_days){
  for(int i = 0; i < blocked_days.size(); i++)
    cout << "(" << blocked_days[i].start << "," << blocked_days[i].end << ")" << endl;
}

bool Overlaps(interval a, interval b){
  if(a.start >= b.start && a.start <= b.end)
    return true;
  if(a.end >= b.start && a.end <= b.end)
    return true;
  if(b.start >= a.start && b.start <= a.end)
    return true;
  if(b.end >= a.start && b.end <= a.end)
    return true;
  // we'll also call it an overlap if two intervals touch
  if(a.end +1 == b.start || b.end+1 == a.start)
    return true;
  return false;
}

void Merge_Intervals(vector<interval>& blocked_days){
  int i = 0;
  // cout << "-----" << endl;
  //  cout << "Squeezing: ";
    //  Print_Intervals(blocked_days);
  //  cout << "-----" << endl;
  for(int i = 0; i < blocked_days.size(); i++){
    int j = i+1;
    while(j < blocked_days.size()){
      if(Overlaps(blocked_days[i], blocked_days[j])){
	  blocked_days[i].start = min(blocked_days[i].start, blocked_days[j].start);
	  blocked_days[i].end = max(blocked_days[i].end, blocked_days[j].end);
	  blocked_days.erase(blocked_days.begin()+j);
	  i = -1;
	  j = blocked_days.size();
      }
	else
	  j++;
    }
  }
}
	
// Pre: blocked_days has no overlaps
// Post: returns the closest party and merges intervals so blocked_days
//       still has no overlaps
int Find_Party(int birthday, int dist, vector<interval>& blocked_days){
  int party_day = birthday;
  for(int i = 0; i < blocked_days.size(); i++){
    if(birthday >= blocked_days[i].start && birthday <= blocked_days[i].end){
      int before = blocked_days[i].start-1;
      int after = blocked_days[i].end+1;
      if(birthday-before <= after-birthday)
	party_day = before;
      else
	party_day = after;
    }
  }

  interval new_interval;
  new_interval.start = party_day-dist;
  new_interval.end = party_day+dist;

  blocked_days.push_back(new_interval);
  Merge_Intervals(blocked_days);
  return party_day;
}

int main(){
  int n,r;
  cin >> n >> r;
  int cur_case = 1;
  while(n > 0){
    vector<int> birthdays(n);
    for(int i = 0; i < n; i++)
      cin >> birthdays[i];


    vector<interval> blocked_days;

    cout << "Case " << cur_case << ": ";
    for(int i = 0; i < n; i++){
      int party_day = Find_Party(birthdays[i], r-1, blocked_days);
      cout << party_day << " ";
      //      Print_Intervals(blocked_days);
    }
    cout << endl;
    cur_case++;
    cin >> n >> r;
  }
  return 0;
}
      
   
