#include <iostream>
#include <string>
#include <vector>

using namespace std;

struct dvd{
  string disc;
  string ccase; // because "case" is a reserved word
};

int Find_Case(const vector<dvd>& collection, string title){
  for(int i = 0; i < collection.size(); i++){
    if(collection[i].ccase == title)
      return i;
  }
  return -1;
}

     
int main(){
  int cur_case = 1;
  int d;
  cin >> d;
  while(d > 0){
    vector<dvd> collection(d);
    vector<int> chain_starters;
    for(int i = 0; i < d; i++){
      cin >> collection[i].disc;
      cin >> collection[i].ccase;
      if(collection[i].ccase == "None")
	chain_starters.push_back(i);
    }

    int max_chain = 0;
    for(int i = 0; i < chain_starters.size(); i++){
      int cur_chain = 1;
      int cur_pos = chain_starters[i];
      string cur_disc = collection[cur_pos].disc;
      int next_pos = Find_Case(collection, cur_disc);
      while(next_pos != -1){
	//cout << "Placing " << cur_disc << endl;
	cur_pos = next_pos;
	cur_chain++;
	cur_disc = collection[cur_pos].disc;
	next_pos = Find_Case(collection, cur_disc);
      }
      if(cur_chain > max_chain)
	max_chain = cur_chain;
    }
    cout << "Case " << cur_case << ": " << chain_starters.size() << " " << max_chain << endl;
    cin >> d;
    cur_case++;
  }
  return 0;
}
