#include <iostream>
#include <vector>

using namespace std;

struct stop{
  int m;
  int p;
};

int Solve(const vector<stop>& all_stops, int cur_stop, int stop_dist, int stops_remaining, vector<vector<int> >& memo){
  if(cur_stop >= all_stops.size() && stops_remaining >= 0)
    return 0;
  if(stops_remaining < 0)
    return -10000000;
  if(memo[cur_stop][stops_remaining] != -1)
    return memo[cur_stop][stops_remaining];

  // try stopping here
  int next_stop = cur_stop+1;
  while(next_stop < all_stops.size() && all_stops[next_stop].m - all_stops[cur_stop].m < stop_dist)
    next_stop++;
  int stop_score = all_stops[cur_stop].p + Solve(all_stops, next_stop, stop_dist, stops_remaining-1, memo);
  // try not stopping here
  int skip_score = Solve(all_stops, cur_stop+1, stop_dist, stops_remaining, memo);
  int best_score = max(stop_score, skip_score);
  memo[cur_stop][stops_remaining] = best_score;
  return best_score;
}

  
  int main(){
  int cur_case = 1;
  int n;
  cin >> n;
  while(n > 0){
    int k;
    int d;
    cin >> k >> d;
    vector<stop> all_stops(n);
    for(int i = 0; i < n; i++){
      cin >> all_stops[i].m;
      cin >> all_stops[i].p;
    }

    vector<vector<int> > memo(n);
    for(int i = 0; i < n; i++)
      memo[i].resize(k+1, -1);

    int best = Solve(all_stops, 0, d, k, memo);
    cout << "Case " << cur_case << ": " << best << endl;
    cin >> n;
    cur_case++;
  }
  return 0;
}

    
