#include <iostream>
#include <cmath>

using namespace std;


// finds the row and column of n
void Position_Of(int n, int& r, int& c){
  if(n == 1){
    r = 0;
    c = 0;
    return;
  }
  

  int side_length = 1;
  // ring 1,3,5,7, ... forms a square of size side_length x side_length
  // yes, this should be a formula, not a loop
  while(side_length * side_length < n)
    side_length = side_length + 2;

  
  int remaining = n- pow(side_length-2,2);


  int dist = side_length/2; // distance of ring from origin
  if(remaining < side_length){ // right
    r = -1*dist + remaining;
    c = dist;
  }
  else{
    remaining = remaining - side_length+1; // because we start at the second from the top
    if(remaining < side_length){ // bottom
      r = dist;
      c = dist - remaining;
    }
    else{
      remaining = remaining - side_length+1;
      if(remaining < side_length){ // left
	r = dist - remaining;
	c = -1*dist;
      }
      else{ // top
	remaining = remaining - side_length+1;
	r = -1*dist;
	c = -1*dist + remaining;
      }
    }
  }
  //  cout << "n: " << n << " r: " << r << " c: " << c << endl;
}
  
  
  
int main(){
  int cur_case = 1;
  int x, y;
  cin >> x>> y;
  while(x > 0){
    int r1, c1;
    Position_Of(x, r1, c1);
    int r2, c2;
    Position_Of(y, r2, c2);

    int r_dist = abs(r1-r2);
    int c_dist = abs(c1-c2);

    cout << "Case " << cur_case << ": " << r_dist + c_dist << endl;
    cur_case++;
    cin >> x >> y;
  }
  return 0;
}
