#include <iostream>
#include <vector>

using namespace std;

int Solve(vector<vector<int> >& grid, int r, int c){
  int best = 0;
  int cur = grid[r][c];
  grid[r][c] = 0;
  
  // try all 4 directions
  if(r > 0 && grid[r-1][c] != 0){
    int north = Solve(grid, r-1, c);
    if(north > best)
      best = north;
  }
  if(r < grid.size()-1 && grid[r+1][c] != 0){
    int south = Solve(grid, r+1, c);
    if(south > best)
      best = south;
  }
  if(c > 0 && grid[r][c-1] != 0){
    int west = Solve(grid, r, c-1);
    if(west > best)
      best = west;
  }
  if(c < grid[r].size()-1 && grid[r][c+1] != 0){
    int east = Solve(grid, r, c+1);
    if(east > best)
      best = east;
  }
  // oops, forgot to add in the current space
  best = best + cur;
  grid[r][c] = cur; // replace the tunnel for other options
  //  cout << "Solve( " << r << "," << c << ") returns " << best << endl;
  return best;
}
  
  
int main(){
  int r, c;
  cin >> r >> c;
  int cur_case = 1;
  while(r != 0){
    vector<vector<int> > grid(r);
    for(int i = 0; i < r; i++){
      grid[i].resize(c);
      for(int j = 0; j < c; j++)
	cin >> grid[i][j];
    }

    int best = 0;
    for(int i = 0; i < r; i++)
      for(int j = 0; j < c; j++){
	if(grid[i][j] != 0){
	  int total = Solve(grid, i, j);
	  if(total > best){
	    //   cout << "new best: " << total << " at: (" << i << "," << j << ")" << endl;
	    best = total;
	  }
	}
      }
    cout << "Case " << cur_case << ": " << best << endl;
    cur_case++;
    cin >> r >> c;
  }
  return 0;
}
