#include <iostream>
#include <vector>
#include <string>
#include <utility>

using namespace std;

bool On_Grid(int r, int c){
  if(r < 0 || c < 0)
    return false;
  if(r >=8 || c >= 8)
    return false;
  return true;
}

bool Legal_Space(vector<vector<char> >& Board, int r, int c){
  if(On_Grid(r,c) && Board[r][c] != '-')
    return true;
  else
    return false;
}

void Find_Possible_Pawn_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  if(Legal_Space(Board, cur_row-1, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col-1));
  if(Legal_Space(Board, cur_row-1, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col+1));
}

// true if we hit a piece before hitting a wall, false otherwise
bool Go_Until_Wall_Or_Piece(vector<vector<char> >& Board, int start_r, int start_c, int offset_r, int offset_c, int& final_r, int& final_c){
  final_r = start_r;
  final_c = start_c;
  while(On_Grid(final_r, final_c) && !Legal_Space(Board, final_r, final_c)){
    final_r += offset_r;
    final_c += offset_c;
  }
  return Legal_Space(Board, final_r, final_c);
}
void Find_Possible_Bishop_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  int dest_r, dest_c;
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, -1, -1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, -1, 1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, 1, -1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, 1, 1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
}

void Find_Possible_Rook_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  int dest_r, dest_c;
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, -1, 0, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, 1, 0, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, 0, -1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
  if(Go_Until_Wall_Or_Piece(Board, cur_row, cur_col, 0, 1, dest_r, dest_c))
    Possible_Moves.push_back(make_pair(dest_r, dest_c));
}

void Find_Possible_Queen_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  Find_Possible_Bishop_Moves(Board, Possible_Moves, cur_row, cur_col);
  Find_Possible_Rook_Moves(Board, Possible_Moves, cur_row, cur_col);
  
}

void Find_Possible_King_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  if(Legal_Space(Board, cur_row-1, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col-1));
  if(Legal_Space(Board, cur_row-1, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col+1));
   if(Legal_Space(Board, cur_row-1, cur_col))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col));
 if(Legal_Space(Board, cur_row, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row, cur_col+1));
 if(Legal_Space(Board, cur_row, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row, cur_col-1));
 if(Legal_Space(Board, cur_row+1, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row+1, cur_col+1));
 if(Legal_Space(Board, cur_row+1, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row+1, cur_col-1));
 if(Legal_Space(Board, cur_row+1, cur_col))
    Possible_Moves.push_back(make_pair(cur_row+1, cur_col));
}

void Find_Possible_Knight_Moves(vector<vector<char> >& Board, vector<pair<int,int> > & Possible_Moves, int cur_row, int cur_col){
  if(Legal_Space(Board, cur_row-1, cur_col-2))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col-2));
  if(Legal_Space(Board, cur_row-1, cur_col+2))
    Possible_Moves.push_back(make_pair(cur_row-1, cur_col+2));
   if(Legal_Space(Board, cur_row-2, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row-2, cur_col-1));
 if(Legal_Space(Board, cur_row-2, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row-2, cur_col+1));
 if(Legal_Space(Board, cur_row+2, cur_col-1))
    Possible_Moves.push_back(make_pair(cur_row+2, cur_col-1));
 if(Legal_Space(Board, cur_row+1, cur_col+2))
    Possible_Moves.push_back(make_pair(cur_row+1, cur_col+2));
 if(Legal_Space(Board, cur_row+1, cur_col-2))
    Possible_Moves.push_back(make_pair(cur_row+1, cur_col-2));
 if(Legal_Space(Board, cur_row+2, cur_col+1))
    Possible_Moves.push_back(make_pair(cur_row+2, cur_col+1));
}
bool Find_Path(vector<vector<char> >& Board, string& cur_path, 
		 int cur_row, int cur_col, int captures_left){
  cur_path = cur_path + Board[cur_row][cur_col];
  if(cur_row == 0 && captures_left == 1){
    
    return true;
  }
  
  // otherwise, we have some work to do
  char my_piece = Board[cur_row][cur_col];
  Board[cur_row][cur_col] = '-';
  vector<pair<int,int> > Possible_Moves;
  switch(my_piece){
  case 'P': 
    Find_Possible_Pawn_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  case 'B':
    Find_Possible_Bishop_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  case 'R':
    Find_Possible_Rook_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  case 'N':
    Find_Possible_Knight_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  case 'Q':
    Find_Possible_Queen_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  case 'K':
    Find_Possible_King_Moves(Board, Possible_Moves, cur_row, cur_col);
    break;
  default:
    cerr << "Trying to move from an empty piece!" << endl;
  }
  for(int i = 0; i < Possible_Moves.size(); i++){
    if(Find_Path(Board, cur_path, Possible_Moves[i].first, Possible_Moves[i].second, captures_left-1))
       return true;
  }
  // if we get here, no possible path works, so..
  Board[cur_row][cur_col] = my_piece;
  cur_path = cur_path.substr(0, cur_path.size()-1);
  return false;
}

       
int main(){
  int n;
  cin >> n;
  for(int cur_case  = 0; cur_case < n; cur_case++){
    vector<vector<char> > Board;
    Board.resize(8);
    int num_pieces = 0;
    for(int i=0; i < 8; i++){
      Board[i].resize(8);
      for(int j = 0; j < 8; j++){
	cin >> Board[i][j];
	if(Board[i][j] != '-')
	  num_pieces++;
      }
    }
    int start_col = -1;
    for(int j = 0; j < 8; j++)
      if(Board[7][j] != '-')
	start_col = j;
    string path = "";
    if(!Find_Path (Board, path, 7, start_col, num_pieces))
        cout << "Board " << cur_case+1 << ": Alice is stuck!" << endl;
    else
      cout << "Board " << cur_case + 1<< ": " << path << endl;
  }
  
  return 0;
}
