#include <iostream>
#include <vector>
#include <utility>

using namespace std;


bool On_Grid(const vector<vector<int> >& v, pair<int, int> pos){
  if(pos.first < 0 || pos.second < 0)
    return false;
  if(pos.first >= v.size() || pos.second >= v[0].size())
    return false;
  return true;
}


bool vector_find(const vector<int>& v, int key){
  for(int i = 0; i < v.size(); i++)
    if(v[i] == key)
      return true;
  return false;
}

int Rect_Dist(pair<int,int> s, pair<int,int> t){
  return abs(s.first-t.first) + abs(s.second-t.second);
}
//uses BFS similar to the walking function below, but all spaces on the same
// bus line are adjacent to each other
int Count_Hops_Between(const vector<vector<vector<int> > > & Bus_Lines, pair<int, int> start, pair<int, int> dest){
  vector<pair<int, int> > frontier;

  vector<vector<int> > Distance_Grid;
  Distance_Grid.resize(Bus_Lines.size());
  for(int i = 0; i < Bus_Lines.size(); i++)
    Distance_Grid[i].resize(Bus_Lines[i].size(), -1);
  vector<int> taken_lines;
  // all stations on all bus lines at the start point are distance 0, 
  // and in our initial frontier
  for(int i = 0; i < Bus_Lines[start.first][start.second].size(); i++){
    int cur_bus = Bus_Lines[start.first][start.second][i];
    taken_lines.push_back(cur_bus);
    for(int r = 0; r < Distance_Grid.size(); r++)
      for(int c = 0; c < Distance_Grid[r].size(); c++){
	if(vector_find(Bus_Lines[r][c], cur_bus)){
	  frontier.push_back(make_pair(r,c));
	  Distance_Grid[r][c] = 0;
	}
      }
  }
  bool found_dest = false;
  int cur_frontier_pos = 0;
  while(!found_dest && cur_frontier_pos < frontier.size()){
    pair<int, int> cur_pos = frontier[cur_frontier_pos];
    if(cur_pos == dest)
      return Distance_Grid[cur_pos.first][cur_pos.second];
    else{
      for(int i = 0; i < Bus_Lines[cur_pos.first][cur_pos.second].size(); i++){
	int cur_bus = Bus_Lines[cur_pos.first][cur_pos.second][i];
	if(!vector_find(taken_lines, cur_bus)){
	  taken_lines.push_back(cur_bus);
	  for(int r = 0; r < Distance_Grid.size(); r++)
	    for(int c = 0; c < Distance_Grid[r].size(); c++){
	      if(vector_find(Bus_Lines[r][c], cur_bus) &&
		 Distance_Grid[r][c] == -1){
		frontier.push_back(make_pair(r,c));
		Distance_Grid[r][c] = Distance_Grid[cur_pos.first][cur_pos.second] + 1;
	      }
	    }
	}
      }
      cur_frontier_pos++;
    }
  }
  return -100;
}
//uses BFS to incrementally try all steps until we hit a square with a
// bus stop
void Create_List_Of_Walkable_Stations(const vector<vector<vector<int> > >& Bus_Lines, vector<pair<int, int> > &Station_List, int r, int c){
  int cur_r = r;
  int cur_c = c;
  vector<pair<int, int> > frontier;
    int cur_distance = 0;
  vector<vector<int> > Distance_Grid;
  Distance_Grid.resize(Bus_Lines.size());
  for(int i = 0; i < Bus_Lines.size(); i++)
    Distance_Grid[i].resize(Bus_Lines[i].size(), -1);

  bool station_found = false;
  Distance_Grid[r][c] = 0;
  frontier.push_back(make_pair(r,c));
  int cur_frontier_pos = 0;
  while(!station_found && cur_frontier_pos < frontier.size()){
    pair<int,int> cur_spot = frontier[cur_frontier_pos];
     cur_distance = Distance_Grid[cur_spot.first][cur_spot.second];
    if(Bus_Lines[cur_spot.first][cur_spot.second].size() != 0) // then stations exist here
      station_found = true;
    else{ // not done yet, check all directions
     
      pair<int,int> new_spot;
      new_spot.first = cur_spot.first;
      new_spot.second = cur_spot.second-1;
      // check all 4 directions
      if(On_Grid(Distance_Grid,new_spot) && Distance_Grid[new_spot.first][new_spot.second] == -1){
	frontier.push_back(new_spot);
	Distance_Grid[new_spot.first][new_spot.second] = cur_distance +1;
      }
      new_spot.second = cur_spot.second+1;
      if(On_Grid(Distance_Grid,new_spot) && Distance_Grid[new_spot.first][new_spot.second] == -1){
	frontier.push_back(new_spot);
	Distance_Grid[new_spot.first][new_spot.second] = cur_distance +1;
      }
      new_spot.first = cur_spot.first-1;
      new_spot.second = cur_spot.second;
      if(On_Grid(Distance_Grid,new_spot) && Distance_Grid[new_spot.first][new_spot.second] == -1){
	frontier.push_back(new_spot);
	Distance_Grid[new_spot.first][new_spot.second] = cur_distance +1;
      }
      new_spot.first = cur_spot.first+1;
      if(On_Grid(Distance_Grid,new_spot) && Distance_Grid[new_spot.first][new_spot.second] == -1){
	frontier.push_back(new_spot);
	Distance_Grid[new_spot.first][new_spot.second] = cur_distance +1;
      }
      cur_frontier_pos++;
    }
    
  }
  // we leave when we find the station.  So every space with that distance 
  // is just as far to walk
  for(int i = 0; i < Distance_Grid.size(); i++)
    for(int j = 0; j < Distance_Grid[i].size(); j++)
      if(Distance_Grid[i][j] == cur_distance && Bus_Lines[i][j].size() != 0 )
	Station_List.push_back(make_pair(i,j));
			       
}

int main(){
  
  int m, n;
  cin >> m>>n;
  int cur_case = 0;
  while(m!=0 && n != 0){
    int r1,c1,r2,c2;
    cin >> r1 >> c1 >> r2 >> c2;
    vector<vector<vector<int> > > Bus_Lines;
    // Bus_Lines[r][c] is the list of lines using grid spot (r,c)
    Bus_Lines.resize(m);
    for(int i = 0; i < m; i++)
      Bus_Lines[i].resize(n);
    int B;
    cin >> B;
    for(int i = 0; i < B; i++){
      int k;
      cin >> k;
      for(int j = 0; j < k; j++){
	int r,c;
	cin >> r >> c;
	Bus_Lines[r][c].push_back(i);
      }
    }
    vector<pair<int,int> > Nearby_Start_Stations;
    Create_List_Of_Walkable_Stations(Bus_Lines, Nearby_Start_Stations, r1,c1);
    vector<pair<int,int> > Nearby_End_Stations;
    Create_List_Of_Walkable_Stations(Bus_Lines, Nearby_End_Stations, r2, c2);
     int min_rides = 25;
    int num_walks = Rect_Dist(make_pair(r1,c1),Nearby_Start_Stations[0]) + 
      Rect_Dist( Nearby_End_Stations[0], make_pair(r2,c2));
    if(num_walks >= Rect_Dist(make_pair(r1,c1), make_pair (r2,c2))){ // go straight there
      num_walks = Rect_Dist(make_pair(r1,c1), make_pair (r2,c2));
      min_rides = -1;  // will cout as 0
    }
    else{
     
      for(int i = 0; i < Nearby_Start_Stations.size(); i++)
	for(int j = 0; j < Nearby_End_Stations.size(); j++){
	  int num_hops = Count_Hops_Between(Bus_Lines, Nearby_Start_Stations[i], Nearby_End_Stations[j]);
	  if(num_hops < min_rides)
	    min_rides = num_hops;
	}
      if(min_rides == -100) // can't get there on the bus
	min_rides = Rect_Dist(make_pair(r1,c1), make_pair (r2,c2));
    }
    cout << "Case " << cur_case+1 << ": Walking " << num_walks<< ", Riding "<< min_rides+1<< endl;
    cin >> m >> n;
    cur_case++;
  }
  return 0;
}
    
