#include <iostream>
#include <vector>
#include <utility>

using namespace std;


// Returns the next student we can accept, if we accept this one. 
// Assumes student list is sorted by time
int Find_Next_Student(const vector<pair<int, int> >& students, int cur_student, int meeting_time){
  bool done = false;
  int next_time = students[cur_student].first + meeting_time + 1;
  while(!done){
    if(cur_student >= students.size())
      done = true;
    if(students[cur_student].first < next_time)
      cur_student++;
    else
      done = true;
  }
  return cur_student;
}

// Dynamic programming recurrence to find the max # of students.
int Solve(const vector<pair<int, int> >& students, vector<vector<int> > & scholarship_memo, int cur_student, int cur_budget, int meeting_time){
  // first, see if we're done.
  if(cur_student >= students.size())
    return 0;

  // next check the memo vector
  if(scholarship_memo[cur_student][cur_budget] != -1)
    return scholarship_memo[cur_student][cur_budget];

  // what's the score from here if we don't accept this student?
  int dont_accept = Solve(students, scholarship_memo, cur_student+1, cur_budget, meeting_time);
  
  // what's the score from here is we _do_ accept this student?
  int accept;
  // can we afford this student?
  if(cur_budget < students[cur_student].second)
    accept = 0;
  else 
    accept = 1+ Solve(students, scholarship_memo, Find_Next_Student(students, cur_student, meeting_time), cur_budget - students[cur_student].second, meeting_time);
  
  int best = max(dont_accept, accept);
  scholarship_memo[cur_student][cur_budget] = best;
  return best;
}

void Swap(pair<int,int> &x, pair<int,int> & y){
  pair<int,int> temp = x;
  x = y;
  y = temp;
}
// time is the first element of the pair.  Since there are at most 100 students,
// I'll be lazy and use bubblesort
void Sort_By_Time(vector<pair<int,int> >& v){
  for(int i = 0; i < v.size(); i++)
    for(int j = 0; j < v.size() -1; j++){
      if(v[j].first > v[j+1].first)
	Swap(v[j], v[j+1]);
    }
}
int main(){
  int n;
  cin >> n;
  int cur_case = 1;
  while(n > 0){
    int b,m;
    cin >> m >> b;
    
    vector<pair<int, int> > students(n);
    for(int i = 0; i < n; i++){
      int mil_time;
      cin >> mil_time;
      int minutes = mil_time % 100;
      if(minutes >= 60)
	cout << "Illegal time" << mil_time << endl;
      students[i].first = mil_time/100 * 60 + mil_time % 100; // convert to minutes past midnight
      cin >> students[i].second;
    }
    Sort_By_Time(students);
    vector<vector<int> > scholarship_memo;
    scholarship_memo.resize(n);
    for(int i = 0; i < n; i++){
      scholarship_memo[i].resize(1001,-1);
    }
    int num_students = Solve(students, scholarship_memo, 0,b, m);
    cout << "Case " << cur_case << ": "<< num_students << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}
