#include <vector>
#include <iostream>
using namespace std;


bool Win_Check(const vector<vector<vector<int> > >& Board, int cur_player){
  int n = Board.size();

  // first, check for n in a row
  for(int i = 0; i < Board.size(); i++)
    for(int j = 0; j < Board.size(); j++){
      if(Board[i][j].size() == Board.size()){
	int k = 0;
	while(k < Board.size() && Board[i][j][k] == cur_player){
	  k++;
	}
	if(k == Board.size())
	  return true;
      }
    }
  // it will be easier to work on a 2d slice of the top of the board
  vector<vector<int> > Board_Top(Board.size());
  for(int i = 0; i < n; i++){
    Board_Top[i].resize(n);
    for(int j = 0; j < n; j++){
      if(Board[i][j].size() == 0)
	Board_Top[i][j] = 0;
      else
	Board_Top[i][j] = Board[i][j][Board[i][j].size()-1];
    }
  }
  // check horizontal
  for(int i = 0; i < n; i++){
    int j = 0;
    while(j < n && Board_Top[i][j] == cur_player)
      j++;
    if(j == Board.size())
      return true;
  }
  //check vertical
  for(int i = 0; i < n; i++){
    int j = 0;
    while(j <n && Board_Top[j][i] == cur_player)
      j++;
    if(j == Board.size())
      return true;
  }
  // Check (1,1) to (n-1,n-1) diagonal
  int i = 0; 
  while(i < n && Board_Top[i][i] == cur_player)
    i++;
  if(i == Board.size())
    return true;

  // check other diagonal
  i = 0;
  while(i < n && Board_Top[i][n-i-1] == cur_player)
    i++;
  if(i == Board.size())
    return true;

  // if none work, return false;
  return false;
}
	

int Has_Win (vector<vector<vector<int> > >& Board, int cur_player){
  for(int i = 0; i < Board.size(); i++)
    for(int j = 0; j < Board.size(); j++){
      if(Board[i][j].size() < Board.size()){
	Board[i][j].push_back(cur_player);
	if(Win_Check(Board, cur_player)){
	  Board[i][j].pop_back();
	  return i*Board.size()+j+1;
	}
	Board[i][j].pop_back();
      }
    }
  return -1;
}

int main(){
  int n;
  int cur_case = 1;
  cin >> n;
  while(n > 0){
    vector<vector<vector<int> > >  Board(n);
    for(int i = 0; i < n; i++){
      Board[i].resize(n);
      for(int j = 0; j < n; j++){
	int num_pieces;
	cin >> num_pieces;
	Board[i][j].resize(num_pieces);
	for(int k = 0; k < num_pieces; k++)
	  cin >> Board[i][j][k];
      }
    }
    int cur_player;
    cin >> cur_player;
    int win_pos = Has_Win (Board, cur_player);
    if(win_pos > 0)
      cout << "Board " << cur_case << ": Winning move at peg " << win_pos << endl;
    else{
      vector<int> Safe_Moves;
      for(int i = 0; i < n; i++){
	for(int j = 0; j < n; j++){
	  if(Board[i][j].size() < n){
	    Board[i][j].push_back(cur_player);
	    int other_win_pos = Has_Win(Board, (cur_player==1)?2:1);
	    if(other_win_pos <= 0)
	      Safe_Moves.push_back(i*n+j+1);
	    Board[i][j].pop_back();
	  }
	}
      }
      if(Safe_Moves.size() > 0){
	cout << "Board " << cur_case << ": Safe moves at: ";
	for(int i = 0; i < Safe_Moves.size() -1; i++)
	  cout << Safe_Moves[i] << " ";
	cout << Safe_Moves[Safe_Moves.size()-1] << endl;
      }
      else{
	cout << "Board " << cur_case << ": No safe moves found!" << endl;
      }
    }
    cur_case++;
    cin >> n;
  }
  return 0;
}
