#include <iostream>
#include <vector>
#include <string>
using namespace std;

template <typename T>
int find(const vector<T>& v, T key){
  for(int i = 0; i < v.size(); i++)
    if(v[i] == key)
      return i;

  return -1;
}

// Finds the best price for component "cur".  If it builds other stuff, finds the best price for those first.
// Can be donne faster by using memoization to see if we've priced this item before- we'll see if it's necessary.
int Find_Best_Price(int cur, const vector<vector<int> >& Components, vector<int>& Prices, const vector<int> Market_Prices){
  // See who else uses this item
  int best = Prices[cur];
  for(int i = 0; i < Components.size(); i++){
    if(find(Components[i], cur) != -1){ // we make item i
      Prices[i] = Find_Best_Price(i, Components, Prices, Market_Prices);
      int this_price = Prices[i];
      bool found_me = false;
      int Component_Cost = 0;
      for(int j = 0; j < Components[i].size(); j++){
	if(Components[i][j] == cur && !found_me)
	  found_me = true;
	else
	  Component_Cost = Component_Cost + Market_Prices[Components[i][j]];
      }
      this_price = this_price - Component_Cost;
      if(this_price > best)
	best = this_price;
    }
  }
  Prices[cur] = best;
  return best;
}
							  
	  
int main(){
  int n;
  cin >> n;
  int cur_set = 1;
  while(n > 0){
    vector<string> Itemnames(n);
    for(int i = 0; i < n; i++){
      cin >> Itemnames[i];
    }
    vector<vector<int > > Components(n);
    vector<int> Prices(n);
    vector<int> Market_Prices(n);
    for(int i = 0; i < n; i++){
      int num_components;
      cin >> num_components;
      Components[i].resize(num_components);
      for(int j = 0; j < num_components; j++){
	string component_name;
	cin >> component_name;
	Components[i][j] = find(Itemnames, component_name);
      }
      cin >> Prices[i];
      Market_Prices[i] = Prices[i];
    }
    
    for(int i = 0; i < n; i++){
      Prices[i] = Find_Best_Price(i, Components, Prices, Market_Prices);
    }
    cout << "Set " << cur_set << ":" << endl;
    for(int i = 0; i < n; i++){
      cout << Itemnames[i] << " has a profit of " << Prices[i] << endl;
    }
    cout << endl;
    cur_set++;
    cin >> n;
  }
  return 0;
}
      
      
