#include <iostream>
#include <vector>
#include <iomanip>

using namespace std;

void Print_Park (vector<vector<int> >& Park){
  for(int i = 0; i < Park.size(); i++){
    for(int j = 0; j < Park[i].size(); j++)
      cout << setw(2) << Park[i][j] << " ";
    cout << endl;
  }
}

// turns all contiguous 0's in the Park grid into "Mark", starting at (r,c)
void Flood_Fill(vector<vector<int> >& Park, int mark, int r, int c){
  if(Park[r][c] == 0){
    Park[r][c] = mark;
    if(r > 0)
      Flood_Fill(Park, mark, r-1, c);
    if(r < Park.size()-1)
      Flood_Fill(Park, mark, r+1, c);
    if(c > 0)
      Flood_Fill(Park, mark, r, c-1);
    if(c < Park[r].size()-1)
      Flood_Fill(Park, mark, r, c+1);
  }
}

int Count_Bushes_With_Eggs(vector<int> & Bush_Count, int egg_count){
  int num_matches = 0;
  for(int i = 1; i < Bush_Count.size(); i++)
    if(Bush_Count[i] == egg_count)
       num_matches++;
  return num_matches;
}

int main(){
  int cur_park = 1;
  int r,c;
  cin >> r >> c;
  while(r > 0 && c > 0){
    vector<vector<int> > Park(r);
    for(int i = 0; i < r; i++){
      Park[i].resize(c);
      for(int j = 0; j < c; j++){
	char cur_spot;
	cin >> cur_spot;
	if(cur_spot == '-')
	  Park[i][j] = -1;  // -1 means empty
	else
	  Park[i][j] = 0; // 0 means bush for now.  We're going to number each bush
      }
    }
    int cur_bush = 1;
    for(int i = 0; i < r; i++)
      for(int j = 0; j < c; j++)
	if(Park[i][j] == 0){
	  Flood_Fill(Park, cur_bush, i, j);
	  cur_bush++;
	  //	  Print_Park(Park);
	  //	  cout << endl;
	}
    vector<int> Egg_Count(cur_bush);
    // now, we do something like counting sort to place the eggs in each bush
    int num_eggs;
    cin >> num_eggs;
    for(int i = 0; i < num_eggs; i++){
      int egg_row, egg_col;
      cin >> egg_row >> egg_col;
      Egg_Count[Park[egg_row][egg_col]]++;
    }
    cout << "Park " << cur_park << ":" << endl;
    for(int i = 0; i <= num_eggs; i++){
      int matching_bushes = Count_Bushes_With_Eggs(Egg_Count, i);
      if(matching_bushes > 0){
	cout << matching_bushes << " bush(es) have " << i << " egg(s) underneath them." << endl;
      }
    }
    cur_park++;
    cin >> r >> c;
    cout << endl;
  }
  return 0;
}
       
