#include <iostream>
#include <string>
#include <vector>
using namespace std;



void Swap (char& a, char& b){
  char temp = a;
  a = b;
  b = temp;
}

void BubbleSort(vector<char>& letters){
  for(int i = 0; i < letters.size(); i++)
    for(int j = 0; j < letters.size()-1; j++)
      if(letters[j] > letters[j+1])
	Swap(letters[j], letters[j+1]);
}

int fact(int n){
  if(n <=1)
    return 1;
  else return n*fact(n-1);
}

int find_after(const vector<char>& letters, string done_string, char key){
  int i = 0;
  int result=0;
  while(i < letters.size() && letters[i] != key){
    if(done_string.find(letters[i]) == string::npos)
      result++;
    i++;
  }
  return result;
}

int main(){
  int n;
  cin >> n;
  int cur_case = 1;
  while(n != 0){
    vector<char> letters;
    letters.resize(n);
    for(int i = 0; i < n; i++)
      cin >> letters[i];
    string check_string;
    cin >> check_string;
    BubbleSort(letters);
    // So, the algorithm is:
    // Find out which position in the sorted list our first character is:
    // Then there are that many n-1 factorials that are all of the combinations
    // of all previous letters.
    // Repeat this for each letter
    int running_total = 1;
    for(int i = 0; i < n; i++){
      int letter_position = find_after(letters, check_string.substr(0,i), check_string[i]);
      
      running_total += fact(n-i-1)*letter_position;
    }
    cout << "Case " << cur_case << ": There will be a total of " << running_total << " submission(s)." << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}
    
    
  
