#include <iostream>
#include <vector>

using namespace std;
void print_relationships (const vector<vector<bool> >& relationships){
  for(int i = 0; i < relationships.size(); i++){
    for(int j = 0; j < relationships.size(); j++)
      cout << relationships[i][j] << " ";
    cout << endl;
  }
}

int count_unstable(const vector<vector<bool> >& relationships, bool verbose=false){
  int num_unstable = 0;
  for(int i = 0; i < relationships.size(); i++){
    // make sure you start at i+1 so you don't count both  (1,2,3) and (2,1,3)
    for(int j = i+1; j < relationships.size(); j++){
     	for(int k = j+1; k < relationships.size(); k++){

	    int num_friends = 0;
	    if(relationships[i][j])
	      num_friends++;
	    if(relationships[i][k])
	      num_friends++;
	    if(relationships[j][k])
	      num_friends++;
	    if(num_friends == 0 || num_friends == 2){ // these are the unstable cases
	      num_unstable++;
	      if(verbose)
		cout << "Unstable i=" << i << " j=" << j << " k= " <<k << endl;
	    }
	    
	}
    }
  }
  return num_unstable;
}
		
int main(){
  int n;
  cin >> n;
  int cur_set = 1;
  while(n > 0){
    vector<vector<bool> > relationships(n);
    for(int i = 0; i < n; i++)
      relationships[i].resize(n,false); // false means enemy
    for(int i = 0; i < n; i++){
      int k;
      cin >> k;
      for(int j = 0; j < k; j++){
	int friend_num;
	cin >> friend_num;
	relationships[i][friend_num-1] = true;
      }

    }
    cout << "Set " << cur_set << ":" << endl;
    int num_unstable = count_unstable(relationships);
    cout << "There are currently " << num_unstable << " unstable triangles." << endl;
    int min_unstable = 1141; // 20 choose 3, +1
    int best_i = -1;
    int best_j = -1;
    // print_relationships(relationships);
    for(int i = 0; i < n; i++)
      for(int j = 0; j < n; j++){
	if(i != j){
	  relationships[i][j] = !relationships[i][j];
	  // don't forget symmetry!
	  relationships[j][i] = !relationships[j][i];
	  int new_unstable = count_unstable(relationships);
	  if(new_unstable < min_unstable){
	    min_unstable = new_unstable;
	    best_i = i;
	    best_j = j;
	  }
	  relationships[i][j] = !relationships[i][j];
	  relationships[j][i] = !relationships[j][i];
	  //   print_relationships(relationships);
		  // cout << endl;
	}
      }
    cout << "Making #" << best_i+1 << " and #" << best_j+1;
    if(relationships[best_i][best_j])
      cout << " enemies";
    else
      cout << " friends";
    cout << " results in " << min_unstable << " unstable triangles." << endl;
    cin >> n;
    cur_set++;
    cout << endl;
  }
  return 0;
}
