#include <iostream>
#include <vector>

using namespace std;

int Visit(const vector<vector<bool> >& Adj, int s){
  vector<bool> visited(Adj.size());
  int num_visited = 0;
  vector<int> queue;
  queue.push_back(s);
  num_visited++;
  visited[s] = true;
  while(queue.size() != 0){
    int cur = queue[0];
    queue.erase(queue.begin());
    for(int i = 0; i < Adj.size(); i++){
      if(Adj[cur][i] && !visited[i]){
	num_visited++;
	visited[i] = true;
	queue.push_back(i);
      }
    }
  }
  return num_visited;
}

int main(){
  int n;
  int cur_case = 1;
  cin >> n;
  while(n != 0){
    vector<vector<bool> > Adj(n);
    for(int i = 0; i < n; i++){
      Adj[i].resize(n, false);
      int m;
      cin >> m;
      // cout << i << " ";
      for(int j = 0; j < m; j++){
	int neighbor;
	cin >> neighbor;
	//	cout << "," << j << endl;
	Adj[i][neighbor-1] = true;
      }
    }
    int s;
    cin >> s;
    int num_visited = Visit(Adj, s-1);
    // cout << "Here" << endl;
    int num_added = 0;
    while(num_visited < n){
      vector<vector<bool> > temp = Adj;
      int best = 0;
      int best_i = -1;
      int best_j = -1;
      for(int i = 0; i < n; i++)
	for(int j = 0; j < n; j++){
	  if(i != j && !Adj[i][j]){
	    temp[i][j] = true;
	    int cur = Visit(temp, s-1);
	    temp[i][j] = false;
	    if(cur > best){
	      best = cur;
	      best_i = i;
	      best_j = j;
	      
	    }
	  }
	}
      num_visited = best;
      Adj[best_i][best_j] = true;
      num_added++;
    }
    cout << "Case " << cur_case << ": " << num_added << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}

    
