#include <iostream>
#include <vector>

using namespace std;

void Print_Grid(const vector<vector<char> >& Grid){
  for(int i = 0; i < Grid.size(); i++){
    for(int j = 0; j < Grid[i].size(); j++)
      cout << Grid[i][j];
    cout << endl;
  }
  cout << endl;
}

int Count_Empty(const vector<vector<char> >& Grid){
  int total = 0;
  for(int i = 0; i < Grid.size(); i++)
    for(int j = 0; j < Grid[i].size(); j++)
      if(Grid[i][j] == '!')
	total++;
  return total;
}

bool On_Grid(const vector<vector<char> >& Grid, int r, int c){
  if(r < 0 || r >= Grid.size() || c < 0 || c >= Grid[0].size())
     return false;
   else
     return true;
}

void Swap(char& a, char& b){
  char temp = a;
  a = b;
  b = temp;
}

void Drop_Col(vector<vector<char> >& Grid, int col){
  for(int i = Grid.size()-1; i >=0; i--){
    for(int j = Grid.size()-1; j > 0; j--){
      if(Grid[j][col] == '-')
	Swap(Grid[j][col], Grid[j-1][col]);
    }
  }
}

void Drop(vector<vector<char> >& Grid){
  for(int j = 0; j < Grid[0].size(); j++){
    Drop_Col(Grid, j);
  }
  for(int i = 0; i < Grid.size(); i++)
    for(int j = 0; j < Grid[i].size(); j++)
      if(Grid[i][j] == '-')
	Grid[i][j] = '!';
}

// '-' means it's removed on this turn
// '!' means it came in from the top on a previous turn
int Cascade(vector<vector<char> >& Grid){
  int num_matched = 0;
  vector<vector<char> > Temp = Grid;
  for(int i = 0; i < Grid.size(); i++)
    for(int j = 0; j < Grid[i].size(); j++){
      if(Grid[i][j] != '-' && Grid[i][j] != '!'){
	// check horizontal
	int num_in_a_row = 1;
	int cur_j = j+1;
	while(cur_j < Grid[i].size() && Grid[i][j] == Grid[i][cur_j]){
	  cur_j++;
	  num_in_a_row++;
	}
	if(num_in_a_row >= 3){
	  for(int k = 0; k < num_in_a_row; k++){
	    Temp[i][j + k] = '-';
	  }
	  num_matched += num_in_a_row;
	}
	// check vertical
	num_in_a_row = 1;
	int cur_i = i+1;
	while(cur_i < Grid.size() && Grid[i][j] == Grid[cur_i][j]){
	  cur_i++;
	  num_in_a_row++;
	}
	if(num_in_a_row >= 3){
	  for(int k = 0; k < num_in_a_row; k++){
	    Temp[i+k][j] = '-';
	  }
	  num_matched += num_in_a_row;
	}
      }
    }
  Grid = Temp;
  if(num_matched > 0){
    //  cout << "Before: " << endl;
    // Print_Grid(Grid);
    Drop(Grid);
    //  cout << "After: " << endl;
    //   Print_Grid(Grid);
     return Cascade(Grid);
  }
  else return Count_Empty(Grid);

}
      
// sees how many pieces are removed when swapping (r1,c1) with (r2,c2)
int Try_Move(vector<vector<char> >& Grid, int r1, int c1, int r2, int c2){
    if(!On_Grid(Grid, r1, c1) || !On_Grid(Grid, r2,c2))
       // swapping with something off the board
    return 0;
  else{
    vector<vector<char> > Temp = Grid;
    char t = Temp[r1][c1];
    Temp[r1][c1] = Temp[r2][c2];
    Temp[r2][c2] = t;
    return Cascade(Temp);
  }
}
int main(){
  int n, m;
  cin >> m >> n;
  int cur_case = 1;
  while(m > 0){
    vector<vector<char> > Grid(m);
    for(int i = 0; i < m; i++){
      Grid[i].resize(n);
      for(int j = 0; j < n; j++)
	cin >> Grid[i][j];
    }
    
    int most_removals = 0;
    for(int i = 0; i < m; i++)
      for(int j = 0; j < n; j++){

	int score = Try_Move(Grid, i, j, i-1, j);
	if(score > most_removals){
	  most_removals = score;
	  //	  cout << "Swapping " << i << "," << j << " with " << i-1 << "," << j << "gets " << score << endl;
	}

	score = Try_Move(Grid,i,j,i+1, j);
	if(score > most_removals){
	  most_removals = score;
	  //   cout << "Swapping " << i << "," << j << " with " << i+1 << "," << j << "gets " << score << endl;
	}
	score = Try_Move(Grid,i,j,i,j-1);
	if(score > most_removals){
	  most_removals = score;
	  //	   cout << "Swapping " << i << "," << j << " with " << i << "," << j-1 << "gets " << score << endl;
	}
	score = Try_Move(Grid,i,j, i, j+1);
	if(score > most_removals){
	  most_removals = score;
	  //   cout << "Swapping " << i << "," << j << " with " << i << "," << j+1 << "gets " << score << endl;
	}
      }
    cout << "Case " << cur_case << ": " << most_removals << endl;
    cur_case++;
    cin >> m >> n;
  }
  return 0;
}
	
