#include <iostream>
#include <vector>

using namespace std;

// solves the recurrence from position "cur" to the end.  "first_taken" tells
// is if we've taken the first house (since it's a circle)
int Solve(const vector<int>& amounts, vector<int>& amounts_memo, int cur, int first_taken){
  if(cur >= amounts.size())
    return 0;
  if(amounts_memo[cur] != -1)
    return amounts_memo[cur];
  if(cur != amounts.size() -1){
    // don't visit this house
    int temp = Solve(amounts, amounts_memo, cur+1, first_taken);
    // do visit this house
    int temp2 = amounts[cur] + Solve(amounts, amounts_memo, cur+2, first_taken);
    int best = max(temp, temp2);
    amounts_memo[cur] = best;
    return best;
  }
  else{
    if(first_taken){
      // only option is not to take this house
      amounts_memo[cur] = 0;
      return 0;
    }
    else{
      // no reason not to take this house
      amounts_memo[cur] = amounts[cur];
      return amounts[cur];
    }
  }
}
int main(){
  int n;
  int cur_case = 1;
  cin >> n;
  while(n > 0){
    vector<int> amounts(n);
    for(int i = 0; i < n; i++)
      cin >> amounts[i];
    vector<int> amounts_memo(n, -1);
    int result1 = Solve(amounts, amounts_memo, 1, false);
    for(int i = 0; i < n; i++)
      amounts_memo[i] = -1;
    int result2 = Solve(amounts, amounts_memo, 2, true) + amounts[0];
    int best = max(result1, result2);
    cout << "Case " << cur_case << ": " << best << endl;
    cin >> n;
    cur_case++;
  }
  return 0;
}

    
