#include <iostream>
#include <vector>

using namespace std;

void Swap(int& a, int& b){
  int temp = a;
  a = b;
  b = temp;
}

// How many tricks can the winners hand win against the losers?
// The losers are sorted in increasing order.  The winners job is to find the
// smallest card to beat each card
int Find_Winners(const vector<int>& losers, const vector<int>& winners){
  vector<bool> taken(winners.size(), false);
  int cur_card = 0;
  bool found_winner = true;
  while(cur_card < losers.size() && found_winner){
    found_winner = false;
    int smallest_winner;
    int smallest_pos;
    for(int i = 0; i < winners.size(); i++){
      if(winners[i] > losers[cur_card] && !taken[i]){
	if(!found_winner){
	  found_winner = true;
	  smallest_winner = winners[i];
	  smallest_pos = i;
	}
	else{
	  if(winners[i] < smallest_winner){
	    smallest_winner = winners[i];
	    smallest_pos = i;
	  }
	}
      }
    }
    if(found_winner)
      taken[smallest_pos] = true;
    if(found_winner)
      cur_card++;
  }
  return cur_card;
}
void Sort(vector<int>& v){
  for(int i = 0; i < v.size(); i++)
    for(int j = 0; j < v.size()-1; j++)
      if(v[j] > v[j+1])
	Swap(v[j], v[j+1]);
}

int main(){
  int n;
  int cur_case = 1;
  cin >> n;
  while(n > 0){
    vector<int> Hand_A(n);
    vector<int> Hand_B(n);
    for(int i = 0; i < n; i++)
      cin >> Hand_A[i];
    for(int i = 0; i < n; i++)
      cin >> Hand_B[i];
    Sort(Hand_A);
    int max = Find_Winners(Hand_A, Hand_B);
    Sort(Hand_B);
    int min = Find_Winners(Hand_B, Hand_A);
    cout << "Case " << cur_case << ": " << min << " " << max << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}

