#include <iostream>
#include <vector>
#include <cmath>

using namespace std;

struct point{
  point(double x1=0, double y1 = 0){ x = x1, y = y1;}

  double x;
  double y;
};
point operator-(const point& p, const point& q){
    point result;
    result.x = p.x-q.x;
    result.y = p.y-q.y;
    return result;
}
struct line{
  double x1;
  double y1;
  double x2;
  double y2;
};


double Cross(point p1, point p2){
  return (p1.x*p2.y) - (p2.x*p1.y);
}
double Direction(point pi, point pj, point pk){
  return Cross(pk-pi, pj-pi);
}

// returns true if "line" and "trail" intersect.  "trail" is infinitely
// long, "line" isn't
bool Intersects(line walk, line trail){
  point p1(walk.x1, walk.y1);
  point p2(walk.x2, walk.y2);
  point p3(trail.x1, trail.y1);
  point p4(trail.x2, trail.y2);
  
  double d1 = Direction(p3,p4,p1);
  double d2 = Direction(p3,p4,p2);
  double d3 = Direction(p1,p2,p3);
  double d4 = Direction(p1,p2,p4);

  if((d1 > 0 && d2 < 0) || (d1 < 0 && d2 > 0) ||
     (d1 == 0) || (d2 == 0))
    return true;
  else
    return false;
}


int main(){
  int n;
  cin >> n;
  for(int i = 0; i < n; i++){
    line trail;
    cin >> trail.x1;
    cin >> trail.y1;
    cin >> trail.x2;
    cin >> trail.y2;
    int k,d;
    cin >> k >> d;
    bool found = false;
    int num_trips = 0;
    double cur_angle = 0;
    int cur_dist = d;
    while(!found){
   
      line walk;
      walk.x1 = 0;
      walk.y1 = 0;
      walk.x2 = cur_dist * sin(cur_angle);
      walk.y2 = cur_dist * cos(cur_angle);
      if(Intersects(walk, trail))
	found = true;
      //cout << "Angle = " << cur_angle << endl;
      // cout << "(" << walk.x2 << "," << walk.y2 << ")" << endl;
      num_trips++;
      if(num_trips % k == 0){
	cur_angle = 0;
	cur_dist = cur_dist + d;
      }
      else
	cur_angle = cur_angle + 2*M_PI / k;
    }
  
    cout << "Case " << i+1 << ": " << num_trips << endl;
  }
  return 0;
}

      
      
    
