#include <iostream>
#include <vector>
#include <string>


using namespace std;

bool On_Grid(vector<vector<char> >& Board, int r, int c){
  if(r >=0 && r < Board.size() && c >= 0 && c < Board.size())
    return true;
  else
    return false;
}

bool Find_Word_Aux(vector<vector<char> >& Board, const string& word,
		   int r, int c, int pos){
  if(pos == word.size())
    return true;
  for(int dr = -1; dr <= 1; dr++)
    for(int dc = -1; dc <=1; dc++){
      int new_row = r+dr;
      int new_col = c+dc;
      if(On_Grid(Board, new_row, new_col) && word[pos] == Board[new_row][new_col]){
	Board[new_row][new_col] = '-';
	if(Find_Word_Aux(Board, word, new_row, new_col, pos+1))
	  return true;
	Board[new_row][new_col] = word[pos];
      }
    }
  return false;
}

void Deep_Copy(vector<vector<char> >& source, vector<vector<char> >& dest){
  dest.resize(source.size());
  for(int i = 0; i < dest.size(); i++)
    dest[i].resize(source[i].size());
  for(int i = 0; i < dest.size(); i++)
    for(int j = 0; j < source.size(); j++)
      dest[i][j] = source[i][j];
}

bool Find_Word(vector<vector<char> >& Board, const string& word){
  for(int i = 0; i < Board.size(); i++){
    for(int j = 0; j < Board[i].size(); j++){
      if(Board[i][j] == word[0]){
	vector<vector<char> > Board_Copy;
	Deep_Copy(Board, Board_Copy);
	Board_Copy[i][j] = '-';
	if(Find_Word_Aux(Board_Copy, word, i, j, 1))
	  return true;
      }
    }
  }
  return false;
}

int main(){
  int cur_case = 1;
  int n;
  cin >> n;
  while(n > 0){
    vector<vector<char> > Board(n);
    for(int i = 0; i < n; i++)
      Board[i].resize(n);
    for(int i = 0; i < n; i++)
      for(int j = 0; j < n; j++)
	cin >> Board[i][j];
    cout << "Board " << cur_case << endl;
    int num_words;
    cin >> num_words;
    for(int i = 0; i < num_words; i++){
      string  word;
      cin >> word;
     
      if(Find_Word(Board, word)){
	cout << "Word " << i+1 << ": yes" << endl;
      }
      else{
	cout << "Word " << i+1 << ": no" << endl;
      }
    }
    cin >> n;
    cur_case++;
  }
  return 0;
}
