#include <iostream>
#include <vector>

using namespace std;

void Print_Vector(const vector<int>& v){
  for(int i = 0; i < v.size(); i++)
    cout << v[i] << " ";
  cout << endl;
  }


void Sort(vector<int> & sorted, vector<int>& frequency, vector<int>& denom){
  for(int i = 0; i < sorted.size(); i++){
    int max = -1;
    int max_pos = -1;
    for(int j = 0; j < frequency.size(); j++){
      if(frequency[j] >= max){
	max = frequency[j];
	max_pos = j;
      }
    }
    sorted[i] = denom[max_pos];
    frequency[max_pos] = -1;
  }
}

int main(){
  int d;
  int cur_case = 1;
  cin >> d;
  while(d > 0){
    vector<int> denom(d);
    for(int i = 0; i < d; i++){
      cin >> denom[i];
    }
    vector<int> frequency(d,0);
    int n;
    cin >> n;
    for(int i = 1; i <=n; i++){
      int cur = i;
      for(int j = 0; j < d; j++){
	frequency[j] += cur/denom[j];
	cur -= (cur/denom[j]) * denom[j];
      }
    }
    vector<int> sorted(d);
    //  Print_Vector(frequency);
    Sort(sorted, frequency, denom);
    cout << "Case " << cur_case << ": ";
    for(int i = 0; i < sorted.size(); i++){
      cout << sorted[i] << " ";
    }
    cout << endl; 
    cur_case++;
    cin >> d;
  }
  return 0;
}
	 
    
