#include <iostream>
#include <vector>

using namespace std;

void Print_Board(const vector<vector<char> >& Board){
  for(int i = 0; i < Board.size(); i++){
    for(int j = 0; j < Board[i].size(); j++)
      cout << Board[i][j] ;
    cout << endl;
  }
}

bool On_Grid(vector<vector<char > >& Board, int r, int c){
  if(r >= 0 && c >=0 && r < Board.size() && c < Board[r].size())
    return true;
  else
    return false;
}


int Flood_Fill(vector<vector<char> >& Board, int i, int j, bool& seen_b, bool& seen_w){
  if(!On_Grid(Board, i,j))
    return 0;
  if(Board[i][j] == 'B'){
    seen_b = true;
    return 0;
  }
  if(Board[i][j] == 'W'){
    seen_w = true;
    return 0;
  }
  if(Board[i][j] == '-'){
    Board[i][j] = '!';
    return 1 + Flood_Fill(Board, i-1, j, seen_b, seen_w) +
      Flood_Fill(Board, i+1, j, seen_b, seen_w) +
      Flood_Fill(Board, i, j-1, seen_b, seen_w) +
      Flood_Fill(Board, i, j+1, seen_b, seen_w);
  }
}
    
void Count_Eyes(vector<vector<char> >& Board, int& white_spaces, int& black_spaces){
  for(int i = 0; i < Board.size(); i++){
    for(int j = 0; j < Board[i].size(); j++){
      if(Board[i][j] == '-'){
	bool seen_b = false;
	bool seen_w = false;
	int num_seen = Flood_Fill(Board, i, j, seen_b, seen_w);
	//	Print_Board(Board);
	if(seen_b && !seen_w)
	  black_spaces += num_seen;
	if(seen_w && !seen_b)
	  white_spaces += num_seen;
      }
    }
  }
}
  
  
  
	
int main(){
  int n, m;
  cin >> n >> m;
  int cur_case = 1;
  while(n > 0){
    vector<vector<char> > Board(n);
    for(int i = 0; i < n; i++){
      Board[i].resize(m);
      //  cout << Board[i].size() << endl;
      for(int j = 0; j < m; j++){
	cin >> Board[i][j];
      }
    }
    //  cout << "n = " << n << " m = " << m << endl;
    //   Print_Board(Board);
    int white_spaces = 0;
    int black_spaces = 0;
    Count_Eyes(Board, white_spaces, black_spaces );
   
    cout << "Case " << cur_case << ": " << black_spaces << " " << white_spaces << endl;
    cur_case++;
    cin >> n >> m;
  }

  return 0;
}

	
