#include <iostream>
#include <vector>

using namespace std;


int Solve(vector<int>& memo, const vector<int>& fabrics, int length, int slop){
  if(length < -1*slop)
    return memo.size();
  if(length <= 0)
    return 0;
  if(memo[length] != -1)
    return memo[length];
  int best = memo.size();
  for(int i = 0; i < fabrics.size(); i++){
    int cur = 1+ Solve(memo, fabrics, length-fabrics[i], slop);
    if(cur < best)
      best = cur;
  }
  memo[length] = best;
  return best;
}

int main(){
  int n;
  int cur_case = 1;
  cin >> n;
  while(n > 0){
    vector<int> lengths;
    int m;
    cin >> m;
    lengths.resize(m);
    for(int i = 0; i < m; i++){
      cin >> lengths[i];
    }
    int slop;
    cin >> slop;
    vector<int> memo(n+1, -1);
    int result = Solve(memo, lengths, n, slop);
    cout << "Case " << cur_case << ": " << result << endl;
    cur_case++;
    cin >> n;
  }
  return 0;
}
