#include <iostream>
#include <vector>
#include <string>

using namespace std;

// Removes "cur_item" from "wallet".  Reduces the size of "wallet" by 1.
void Remove(vector<string>& wallet, const string& cur_item){
  int i = 0;
  while(wallet[i] != cur_item)
    i++;
  while(i < wallet.size()-1){
    wallet[i] = wallet[i+1];
    i++;
  }
  wallet.resize(wallet.size()-1);
}

// Puts "cur_item" in the wallet at the position right before "pos"
void Replace(vector<string>& wallet, const string& cur_item, int pos){
  wallet.resize(wallet.size()+1);
  int i = wallet.size()-1;
  while(i > pos){
    wallet[i] = wallet[i-1];
    i--;
  }
  wallet[i] = cur_item;
}

void Print_Wallet(const vector<string>& wallet){
  for(int i = 0; i < wallet.size(); i++)
    cout << wallet[i] << endl;
  cout << endl;
}


int main(){
  vector<string> wallet;
  int cur_case = 1;
  int n;
  cin >> n;
  while(n != 0){
    wallet.resize(n);
    for(int i = 0; i < n; i++)
      cin >> wallet[i];
    int k;
    cin >> k;
    for(int i = 0; i < k; i++){
      string cur_item;
      cin >> cur_item;
      Remove(wallet, cur_item);
      char pos;
      cin >> pos;
      int pos_place;
      if(pos == 'F')
	pos_place = 0;
      if(pos == 'B')
	pos_place = wallet.size();
      if(pos == 'M')
	pos_place = wallet.size()/2;
      Replace(wallet, cur_item, pos_place);
    }
    cout << "Wallet " << cur_case << ":" << endl;
    Print_Wallet(wallet);
    cin >> n;
    cur_case++;
  }
  return 0;
}
