#include <iostream>
#include <vector>

using namespace std;

struct flower{
  int b1;
  int b2;
};

int Solve(vector<flower>& times, vector<vector<vector<int> > >& memo, int b1_time, int b2_time, int f){
  if(f >=times.size())
    return max(b1_time, b2_time);
  if(memo[b1_time][b2_time][f] != -1)
    return memo[b1_time][b2_time][f];
  int score1 = Solve(times, memo, b1_time + times[f].b1,  b2_time, f+1);
  int score2 = Solve(times, memo, b1_time, b2_time+times[f].b2, f+1);
  int best = min(score1,score2);
  memo[b1_time][b2_time][f] = best;
  return best;
}

int main(){
  int n;
  cin >> n;
  int cur_case = 1;
  while(n > 0){
    vector<flower> times(n);
    for(int i = 0; i < n; i++){
      cin >> times[i].b1 >> times[i].b2;
    }
    vector<vector<vector<int> > > memo(50*n);
    for(int i = 0; i < memo.size(); i++){
      memo[i].resize(50*n);
      for(int j= 0; j < memo.size(); j++){
	memo[i][j].resize(n, -1);
      }
    }
    
    
    int result = Solve(times, memo, 0,0,0);
    cout << "Case " << cur_case << ": " << result << endl;
    cin >> n;
    cur_case++;
  }
  return 0;
}
