#include <iostream>
#include <vector>

using namespace std;

bool Can_Exit(const vector<vector<char> >& Board, int cur_row, int cur_col, int enter_direction, int exit_row, int exit_col){
  char symbol = Board[cur_row][cur_col];
  if(symbol == '*')
    return true;
  int next_row = cur_row;
  int next_col = cur_col;
  if(enter_direction == 0){ // came from north
    if(symbol == 'L')
      next_col = cur_col+1;
    if(symbol == 'R')
      next_col = cur_col-1;
    if(symbol == 'U')
      next_row = cur_row -1;
    if(symbol == 'S')
      next_row = cur_row + 1;
  }
  if(enter_direction == 1){ // came from east
    if(symbol == 'L')
      next_row = cur_row + 1;
    if(symbol == 'R')
      next_row = cur_row -1;
    if(symbol == 'U')
      next_col = cur_col + 1;
    if(symbol == 'S')
      next_col = cur_col - 1;
  }
  if(enter_direction == 2){ // came from south
    if(symbol == 'L')
      next_col = cur_col -1;
    if(symbol == 'R')
      next_col = cur_col +1;
    if(symbol == 'U')
      next_row = cur_row+1;
    if(symbol == 'S')
      next_row = cur_row -1;
  }
  if(enter_direction == 3){ // came from west
      if(symbol == 'L')
      next_row = cur_row - 1;
    if(symbol == 'R')
      next_row = cur_row + 1;
    if(symbol == 'U')
      next_col = cur_col - 1;
    if(symbol == 'S')
      next_col = cur_col + 1;
  }
  if(next_row == exit_row && next_col == exit_col)
    return true;
  else
    return false;
}
int Solve(const vector<vector<char> >& Board, vector<vector<vector<int> > >& memo, int cur_row, int cur_col, int enter_direction){

 
  int fail_score = Board.size() * Board[0].size() * 8;
  if(cur_row < 0 || cur_row >= Board.size() || cur_col < 0 || cur_col >= Board[0].size())
    return fail_score;
  if(Board[cur_row][cur_col] == 'X')
    return fail_score;
  if(Board[cur_row][cur_col] == '!')
    return 1;
  
  if(memo[cur_row][cur_col][enter_direction] != -1)
    return memo[cur_row][cur_col][enter_direction];
  memo[cur_row][cur_col][enter_direction] = -2; // mark it as open
  int best_score = fail_score;
  if(Can_Exit(Board, cur_row, cur_col, enter_direction, cur_row+1, cur_col)){ // can we leave here going south?
    if(cur_row+1 < Board.size() && memo[cur_row+1][cur_col][0] != -2){
      int cur_score = Solve(Board, memo, cur_row+1, cur_col, 0);
      if(cur_score < best_score)
	best_score = cur_score;
    }
  }
  if(Can_Exit(Board, cur_row, cur_col, enter_direction, cur_row, cur_col-1)){
    if(cur_col > 0 && memo[cur_row][cur_col-1][1] != -2){
      int cur_score = Solve(Board, memo, cur_row, cur_col-1, 1);
      if(cur_score < best_score)
	best_score = cur_score;
    }
  }
  if(Can_Exit(Board, cur_row, cur_col, enter_direction, cur_row-1, cur_col)){
    if(cur_row > 0 && memo[cur_row-1][cur_col][2] != -2){
      int cur_score = Solve(Board, memo, cur_row-1, cur_col, 2);
      if(cur_score < best_score)
	best_score = cur_score;
    }
  }
  if(Can_Exit(Board, cur_row, cur_col, enter_direction, cur_row, cur_col+1)){ 
    if(cur_col < Board[cur_row].size()-1 && memo[cur_row][cur_col+1][3] != -2){
      int cur_score = Solve(Board, memo, cur_row, cur_col+1, 3);
      if(cur_score < best_score)
	best_score = cur_score;
    }
  }
  
  if(best_score < fail_score)
    best_score++;
  memo[cur_row][cur_col][enter_direction] = best_score;
  return best_score;
}

int main(){
  int r, c;
  cin >> r >> c;
  int cur_case = 1;
  while(r > 0){
    vector<vector<char> > Board(r);
    vector<vector<vector<int> > > memo(r);
    for(int i = 0; i < r; i++){
      Board[i].resize(c);
      memo[i].resize(c);
      for(int j = 0; j < c; j++){
	cin >> Board[i][j];
	memo[i][j].resize(4,-1);  //0=north, 1=east, 2=south, 3=west
	
      }
    }
    
    int best_score = r*c*8;
    for(int i = 0; i < r; i++){
      int cur_score = Solve(Board, memo, i, 0, 3);
      if(cur_score < best_score){
	best_score = cur_score;
	//cout << "Enter at row " << i << endl;
      }
      cur_score = Solve(Board, memo, i, c-1, 1);
      if(cur_score < best_score){
	best_score = cur_score;
	//cout << "Enter at row " << i << endl;
      }
    }
    
    for(int j = 0; j < c; j++){
      int cur_score = Solve(Board, memo, 0, j, 0);
      if(cur_score < best_score){
	best_score = cur_score;
	//cout << "Enter at col " << j << endl;
      }
      cur_score = Solve(Board, memo, r-1, j, 2);
      if(cur_score < best_score){
	best_score = cur_score;
	//	cout << "Enter at col " << j << endl;
      }
    }
    if(best_score == r*c*8)
      cout << "Case " << cur_case << ": Impossible" << endl;
    else
      cout << "Case " << cur_case << ": " << best_score << endl;
    cur_case++;
    cin >> r >> c;
  }
  return 0;
}
    
