#include <iostream>
#include <vector>
#include <string>

using namespace std;

void Print_Vec(const vector<vector<bool> >& v){
  for(int i = 0; i < v.size(); i++){
    for(int j = 0; j < v[i].size(); j++)
      cout << v[i][j] << " ";
    cout << endl;
  }
}
void Copy_Vec(vector<vector<bool> >& dest, const vector<vector<bool> >& source){
  dest.resize(source.size());
  for(int i = 0; i < dest.size(); i++){
    dest[i].resize(source[i].size());
    for(int j = 0; j < dest.size(); j++)
      dest[i][j] = source[i][j];
  }
}

void Closure(vector<vector<bool> >& v){
  for(int k = 0; k < v.size(); k++)
    for(int i = 0; i < v.size(); i++)
      for(int j = 0; j < v.size(); j++)
	if(v[i][k] && v[k][j])
	  v[i][j] = true;
}

bool Same_Vec(const vector<vector<bool> >& v1, const vector<vector<bool> >& v2){
  for(int i = 0; i < v1.size(); i++)
    for(int j = 0; j < v1[i].size(); j++)
      if(v1[i][j] != v2[i][j])
	return false;
  return true;
}

int Find(const vector<string>& v, string s){
  for(int i = 0; i < v.size(); i++)
    if(v[i] == s)
      return i;
  return -1;
}
	
int main(){
  int cur_case = 1;
  int c, p;
  cin >> c >> p;
  while(c > 0){
    vector<string> names(c);
    for(int i = 0; i < c; i++)
      cin >> names[i];
    
    vector<vector<bool> > adjacency;
    adjacency.resize(0);
    adjacency.resize(c);
    for(int i = 0; i < c; i++)
      adjacency[i].resize(c, false);
    for(int i = 0; i < p; i++){
      string source;
      string dest;
      cin >> source >> dest;
      int s = Find(names, source);
      int t = Find(names, dest);
      if(s==-1 || t == -1)
	cout << "Oops" << endl;
      adjacency[s][t] = true;
    }

    int num_redundant = 0;
    vector<vector<bool> > reachable;
    Copy_Vec(reachable, adjacency);
    Closure(reachable);
    //  Print_Vec(adjacency);
    //  cout << endl;
    //  Print_Vec(reachable);
    vector<vector<bool> > temp;
    for(int i = 0; i < adjacency.size(); i++)
      for(int j = 0; j < adjacency.size(); j++){
	if(adjacency[i][j]){
	  //  cout << "removing " << i << "," << j << endl;
	  adjacency[i][j] = false;
	  Copy_Vec(temp, adjacency);
	  Closure(temp);
	  //  Print_Vec(adjacency);
	  //   cout << endl;
	  //   Print_Vec(reachable);
	  if(Same_Vec(temp, reachable))
	    num_redundant++;
	  adjacency[i][j] = true;
	}
      }
    cout << "Case " << cur_case << ": " << num_redundant << endl;
    cur_case++;
    cin >> c >> p;
  }
  return 0;
}
